function node_kappa = g_curvature( A )
% Graph Curvature Toolbox is copyrighted by the Regents of the University of Minnesota. 
% Please see readme.txt file for license information
% How to cite: If you use this software for your work, please use the following citation: 
% Farooq, H. et al. Network curvature as a hallmark of brain structural connectivity. Nat Commun 10, 4937 (2019). https://doi.org/10.1038/s41467-019-12915-x
%
G = graph(A);
A_bin = A;
A_bin(A_bin>1)=1;
A_nsparse = A_bin;
A_bin = sparse(A_bin);
A_sp = graphallshortestpaths(A_bin,'directed',false);  
n = max(size(A));
kappa_matrix = zeros(n,n);
Opt_cost1 = zeros(n,n);
Opt_cost2 = zeros(n,n);
for p = 1:n
    parfor m = p:n
        if m == p
            opt_cost1 = 0;
            opt_cost2 = 0;
            kappa = 0;
        else
               d_shortest = A_sp(m,p);
            if d_shortest == inf 
               opt_cost1 = inf;
               opt_cost2 = inf;
               kappa = 0;
            else
                opt_cost1 =d_shortest;
                N1 = neighbors(G,m);
                edge_wt1 = zeros(1,max(size(N1)));
                for i=1:max(size(N1))
                 edge_wt1(:,i)=G.Edges.Weight(findedge(G,m,N1(i)));
                end
                edge_wt1 = edge_wt1./(sum(edge_wt1));
                edge_wt1= edge_wt1.*0.5; 
                p0=[0.5 edge_wt1];  
                N0=[m N1'];         
                N2 = neighbors(G,p); 
                edge_wt2=zeros(1,max(size(N2)));
                for f=1:max(size(N2))
                 edge_wt2(:,f) = G.Edges.Weight(findedge(G,p,N2(f)));
                end
                edge_wt2 = edge_wt2./(sum(edge_wt2));
                edge_wt2 = edge_wt2.*0.5; 
                p1=[0.5 edge_wt2];   
                N_1=[p N2'];         
                C2= A_sp(N0,N_1);
                [ ~, opt_cost2 ] = OMT( p0, p1, C2 );
                kappa = (opt_cost1 - opt_cost2)/opt_cost1;
            end
        end
        kappa_matrix(m,p)=kappa;
        Opt_cost1(m,p)= opt_cost1;
        Opt_cost2(m,p)= opt_cost2;
    end
end
kappa_matrix1=kappa_matrix+kappa_matrix';
kappa_sparse = kappa_matrix1.*A_nsparse;
node_kappa = abs(sum(kappa_sparse,2));
end