%% Calculate graph node curvature for given connectivity matrix
% Graph Curvature Toolbox is copyrighted by the Regents of the University of Minnesota. 
% Please see readme.txt file for license information
% How to cite: If you use this software for your work, please use the following citation: 
% Farooq, H. et al. Network curvature as a hallmark of brain structural connectivity. Nat Commun 10, 4937 (2019). https://doi.org/10.1038/s41467-019-12915-x
%% Variables definition
% A = connectivity matrix of weighted undirected graph
% node_curvature = node curvature for A
close all
clear all
clc
%% Genrate random input matrix for example only
N = 10; 
a = rand(N); b = (a*a')./2;
connectivity_matrix = b - diag(diag(b));
%% Compute node curvature
A = connectivity_matrix;    % load your input graph weighted connectivity matrix
node_curvature = g_curvature( A )
