function f = Aax_exvivo_nlin(x,g,Gamma,G_mag,del,Del,b,D_intra,D_iso,sigma,ydata1)
% x(1) theta (radian)
% x(2) phi (radian)
% x(3) R (micrometers)
% x(4) v=f1/(f1+f2) (0.1 - 0.8)
sinT = sin(x(1));
cosT = cos(x(1));
sinP = sin(x(2));
cosP = cos(x(2));
n = [cosP * sinT, sinP * sinT, cosT];
td=(Del-(del/3)); 
%%%%%%%%%%%%%%%%%%%%%%%%%  CYLINDER %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
L=b*D_intra;
L1=L.*((g*n').^2);
am = [1.84118307861360, 5.33144196877749, 8.53631578218074, 11.7060038949077, 14.8635881488839,  18.0155278304879, 21.1643671187891, 24.3113254834588,  27.4570501848623, 30.6019229722078, 33.7461812269726,  36.8899866873805, 40.0334439409610, 43.1766274212415,  46.3195966792621, 49.4623908440429, 52.6050411092602,  55.7475709551533, 58.8900018651876, 62.0323477967829,  65.1746202084584, 68.3168306640438, 71.4589869258787,  74.6010956133729, 77.7431620631416, 80.8851921057280,  84.0271895462953, 87.1691575709855, 90.3110993488875,  93.4530179063458, 96.5949155953313, 99.7367932203820,  102.878653768715, 106.020498619541, 109.162329055405,  112.304145672561, 115.445950418834, 118.587744574512,  121.729527118091, 124.871300497614, 128.013065217171,  131.154821965250, 134.296570328107, 137.438311926144,  140.580047659913,143.721775748727, 146.863498476739,  150.005215971725, 153.146928691331, 156.288635801966,  159.430338769213, 162.572038308643, 165.713732347338,  168.855423073845, 171.997111729391, 175.138794734935,  178.280475036977, 181.422152668422, 184.563828222242,  187.705499575101];
am2=(am/x(3)).^2;
for i=1:1:60 
 num=(2*D_intra*am2(i)*del)-2+(2*exp(-(D_intra*am2(i)*del)))+...
     (2*exp(-(D_intra*am2(i)*Del)))-(exp(-(D_intra*am2(i)*(Del-del))))...
     -(exp(-(D_intra*am2(i)*(Del+del))));
 den=(D_intra^2)*(am2(i)^3)*((x(3))^2*am2(i)-1); 
 s(:,i)= num./den; 
end
sum1=sum(s,2);
% calc g_per
 for i=1:1:max(size(g)) 
 g_per(i)=(g(i,:)*g(i,:)')-((g(i,:)*n').^2);   % G perpendicular to n
 end
L2=(2*(g_per)'.*(Gamma^2).*sum1.*G_mag.^2);
nG3=L1+L2;                   % cylinder out put
%%%%%%%%%%%%%%%%%%%%%%%% ZEPPLIN %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG4 = (-b .* ((D_intra- (D_intra*(1-x(4))))*((g * n').^2) + (D_intra*(1-x(4)))));
%%%%%%%%%%%%%%%%%%%%%%%%%  Ball %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG5= (D_iso * b); % Ball out put
%%%%%%%%%%%%%%%%%%%%%%%% Dot%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG6=g*[0 0 0]';  % dot out put

A_b=[exp(-nG3) exp(nG4) exp(-nG5) exp(-nG6)];
a_hat=((inv(A_b'*A_b))*A_b')*ydata1;
y_hat=(A_b*a_hat-sigma);    % for offset gaussian  
f=(ydata1-y_hat)'*(ydata1-y_hat);

