%% NODDI model parameter estimation with MIX, using invivo data, used in the original NODDI study 
%  Regents of the University of Minnesota.
% This software is licensed under GPL v3.0.  
% For an alternative license please contact the Office for Technology Commercialization at the University of Minnesota. UMN Reference #20170140.
% How to cite: If you use this software for your work, please use the following citation: 
% Farooq, H. et al. Microstructure Imaging of Crossing (MIX) White Matter Fibers from diffusion MRI. Sci. Rep. 6, 38927; doi: 10.1038/srep38927 (2016).

close all
clear all
clc
%% load xdata
load('noddi_scheme.txt');   % has to be in STEJSKALTANNER format 
xdata=noddi_scheme;
D_intra = 1.7e3;            %(mircometer^2/sec fixed for in vivo)
D_iso= 3.0e3;               %(mircometer^2/sec fixed for in vivo)
Gamma = 2.675987E8;
%% load mask file
% download from NODDI website http://mig.cs.ucl.ac.uk/index.php?n=Tutorial.NODDImatlab
mask = nifti('roi_mask.hdr');
A=mask.dat;
%% load data
% download from NODDI website http://mig.cs.ucl.ac.uk/index.php?n=Tutorial.NODDImatlab
yd=nifti('NODDI_DWI.hdr');
yd1=yd.dat;
%% Recording Results
OD = zeros(size(A,1),size(A,2),size(A,3));
v_iso = zeros(size(A,1),size(A,2),size(A,3));
v_ic = zeros(size(A,1),size(A,2),size(A,3));
theta = zeros(size(A,1),size(A,2),size(A,3));
phi = zeros(size(A,1),size(A,2),size(A,3));
dir = zeros(size(A,1),size(A,2),size(A,3),3);
tic
 for p = 1:size(A,3)
     for n= 1:size(A,2)
         parfor  m= 1:size(A,1)
             if A(m,n,p)>0
                 ydata=squeeze(yd1(m,n,p,:));
                 [f1e, f2e, f3e, ODe, thetae, phie] = nod(xdata,Gamma,D_intra,D_iso,ydata);
                 OD(m,n,p)= ODe;
                 v_iso(m,n,p)=f3e;
                 v_ic(m,n,p)=1-(f2e/(1-f3e)); 
                 theta(m,n,p)= thetae; 
                 phi(m,n,p)= phie; 
                 ne=[cos(phie)*sin(thetae) sin(phie)*sin(thetae) cos(thetae)];
                 dir(m,n,p,:)= ne;
             else
                OD(m,n,p)= 0;
                v_iso(m,n,p)=0;
                v_ic(m,n,p)=0; 
                theta(m,n,p)= 0; 
                phi(m,n,p)= 0; 
                dir(m,n,p,:)= zeros(1,3);
             end
         end
     end
 end
 toc
%% Save nifti files
save_nii( 'synth_mask.nii', OD, 'OD_MIX.nii')
save_nii( 'synth_mask.nii', v_iso, 'v_iso_MIX.nii')
save_nii( 'synth_mask.nii', v_ic, 'v_ic_MIX.nii')
save_nii( 'synth_mask.nii', dir, 'dir_MIX.nii')
%  2016 Regents of the University of Minnesota. All rights reserved.