function f = NOD_getsignal(x,g,G_mag,Del,del,b,f1,f2,f3)
% 
D_intra  = x(1);
OD = x(2);
D_iso= x(3);
sinT=sin(x(4));
cosT=cos(x(4));
sinP=sin(x(5));
cosP=cos(x(5));
n=[cosP*sinT sinP*sinT cosT];

%%%%%%%%%%%%%%%%%%%%%%%%%  IntraCellular ic %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

kappa = 1 ./ tan(OD*pi/2);
signal_ic = SynthMeasWatsonSHCylNeuman_PGSE( [D_intra 0 kappa], g, G_mag, Del, del, n', 0 );
nG3=signal_ic(:,1);
%%%%%%%%%%%%%%%%%%%%%%%% Extra Cellular ec %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
v_ic=f1/(1-f3);
d_perp=D_intra * (1 - v_ic);
signal_ec = SynthMeasWatsonHinderedDiffusion_PGSE( [D_intra d_perp kappa], g, G_mag, Del, del, n' );
nG4=signal_ec(:,1);
%%%%%%%%%%%%%%%%%%%%%%%%%  ISO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nG5= (D_iso * b); % Ball out put  
f=[nG3 nG4 exp(-nG5)]*[f1 f2 f3]';


