function f = noddi_eval_2O(x,xdata)
% x=[f11e f21e f12e f22e f3e OD1 theta1 phi1 OD2 theta2 phi2];
D_intra = 1.7e3;          %(mircometer^2/sec for in vivo human)
D_iso= 3.0e3;
g=[xdata(:,1) xdata(:,2) xdata(:,3)];
G_mag= (xdata(:,4)./1000000); %(Tesla/micro meter)
Del=xdata(:,5);          %(in seconds)
del=xdata(:,6);          %(in seconds)
Gamma = 2.675987E8;
td=(Del-(del/3));        %(in seconds)
b=(td).*((Gamma.*del.*G_mag).^2); %(sec/mircometer^2)
f11=x(1);f21=x(2);f12=x(3); f22=x(4);f3=x(5); 
OD1=x(6); theta1= x(7); phi1= x(8); OD2=x(9); theta2= x(10); phi2= x(11); 
sinT1 = sin(theta1);
cosT1 = cos(theta1);
sinP1 = sin(phi1);
cosP1 = cos(phi1);
n1 = [cosP1*sinT1  sinP1*sinT1  cosT1];
sinT2 = sin(theta2);
cosT2 = cos(theta2);
sinP2 = sin(phi2);
cosP2 = cos(phi2);
n2 = [cosP2*sinT2  sinP2*sinT2  cosT2];
%%%%%%%%%%%%%%%%%%%%%%%%%  IntraCellular ic1 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
kappa1 = 1 ./ tan(OD1*pi/2);
signal_ic1 = SynthMeasWatsonSHCylNeuman_PGSE( [D_intra 0 kappa1], g, G_mag, Del, del, n1', 0 );
nG3=signal_ic1(:,1);
%%%%%%%%%%%%%%%%%%%%%%%% Extra Cellular ec1 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
d_perp1=D_intra * (1 - f11);
signal_ec1 = SynthMeasWatsonHinderedDiffusion_PGSE( [D_intra d_perp1 kappa1], g, G_mag, Del, del, n1');
nG4=signal_ec1(:,1);
%%%%%%%%%%%%%%%%%%%%%%%%%  IntraCellular ic2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
kappa2 = 1 ./ tan(OD2*pi/2);
signal_ic2 = SynthMeasWatsonSHCylNeuman_PGSE( [D_intra 0 kappa2], g, G_mag, Del, del, n2', 0 );
nG5=signal_ic2(:,1);
%%%%%%%%%%%%%%%%%%%%%%%% Extra Cellular ec2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%v_ic=f1/(1-f3);
d_perp2=D_intra * (1 - f12);
signal_ec2 = SynthMeasWatsonHinderedDiffusion_PGSE( [D_intra d_perp2 kappa2], g, G_mag, Del, del, n2' );
nG6=signal_ec2(:,1);
%%%%%%%%%%%%%%%%%%%%%%%%%  ISO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG7= (D_iso * b); 
f=[nG3 nG4 nG5 nG6 exp(-nG7)]*[f11 f21 f12 f22 f3]';
