function [f11_f, f21_f,f12_f,f22_f,f13_f,f23_f,f3_f,theta1_f,phi1_f,R1_f,theta2_f,phi2_f,R2_f,theta3_f,phi3_f,R3_f] = zcd_x(xdata,Gamma,D_intra,ydata)
%% Data Shaping
g=[xdata(:,1) xdata(:,2) xdata(:,3)];
G_mag= (xdata(:,4)./1000000); %(Tesla/micro meter)
Del=xdata(:,5);          %(in seconds)
del=xdata(:,6);          %(in seconds)
td=(Del-(del/3));        %(in seconds)
b=(td).*((Gamma.*del.*G_mag).^2); %(sec/mircometer^2)
ydata1=ydata;
%ydata1=shape_measurements(ydata);
%% Estimation of non-linear parameters using GA 
%GA module used from http://www.acse.dept.shef.ac.uk/cgi-bin/gatbx-download
NIND = 24;           % 24 previously Number of individuals per subpopulations
MAXGEN = 90;        % maximum Number of generations
GGAP = 0.7;           % Generation gap, how many new individuals are created
NVAR = 12;           % Number of variables
PRECI = 15;          % Precision of binary representation
FieldD =[ 15    15    15  15    15    15 15 15 15    15 15 15 ;...
    0.01  0.01    0.1   0.01   0.01   0.1  0.01   0.01   0.1  0.01 0.01 0.01 ;...
    3    3    19  3   3   19 3   3   19 0.8 0.8 0.8;  1   1     1     1 1 1 1 1 1 1 1 1;...
    0    0    0   0   0   0   0   0  0   0   0   0;  1   1     1   1  1  1 1 1 1  1 1 1;  1   1     1     1  1  1 1 1 1  1 1 1];
% Initialise population
   Chrom = crtbp(NIND, NVAR*PRECI);

% Reset counters
   Best = NaN*ones(MAXGEN,1);	% best in current population
   gen = 0;			% generational counter

% Evaluate initial population
par=bs2rv(Chrom,FieldD);
for i=1:NIND
Objv(i)=feval(@ZCDx_nlin,par(i,:),g,Gamma,G_mag,del,Del,b,D_intra,ydata1); 
end 
ObjV=Objv';
% ObjV = objfun1(bs2rv(Chrom,FieldD));

% Track best individual and display convergence
   Best(gen+1) = min(ObjV);
%    plot(log10(Best),'ro');xlabel('generation'); ylabel('log10(f(x))');
%    text(0.5,0.95,['Best = ', num2str(Best(gen+1))],'Units','normalized');   
%    drawnow;        
% Generational loop
   while gen < MAXGEN,

    % Assign fitness-value to entire population
       FitnV = ranking(ObjV);

    % Select individuals for breeding
       SelCh = select('sus', Chrom, FitnV, GGAP);

    % Recombine selected individuals (crossover)
       SelCh = recombin('xovsp',SelCh,0.7);

    % Perform mutation on offspring
       SelCh = mut(SelCh);

    % Evaluate offspring, call objective function
    par1=bs2rv(SelCh,FieldD);
    for i=1:max(size(par1))
    ObjVsel(i)=feval(@ZCDx_nlin,par1(i,:),g,Gamma,G_mag,del,Del,b,D_intra,ydata1); 
    end    
    ObjVSel = ObjVsel';  
    %ObjVSel = objfun1(bs2rv(SelCh,FieldD));

    % Reinsert offspring into current population
       [Chrom ObjV]=reins(Chrom,SelCh,1,1,ObjV,ObjVSel);

    % Increment generational counter
       gen = gen+1;

    % Update display and record current best individual
       Best(gen+1) = min(ObjV);
%        plot(log10(Best),'ro'); xlabel('generation'); ylabel('log10(f(x,y,u))');
%         text(0.5,0.95,['Obj Fun f(x,y,u) = ', num2str(Best(gen+1))],'Units','normalized');
%         drawnow;
   end 
[ObjVSel,ind]=sort(ObjVSel);
par1=par1(ind,:);
x1=par1(1,:);
%% Linear parameters fit using cvx
% toolbox available at http://cvxr.com/cvx/
[A11 A21 A12 A22 A13 A23 A3] = ZCDx_A(x1,g,Gamma,G_mag,del,Del,b,D_intra);
A=[A11 A21 A12 A22 A13 A23 A3];
cvx_begin quiet
    variable f11e 
    variable f21e 
    variable f12e 
    variable f22e 
    variable f13e 
    variable f23e 
    variable f3e 
    fe=[f11e f21e f12e f22e f13e f23e f3e]';
       minimize(norm((ydata1)- A*fe))   
    0 <= f11e <= 1
    0 <= f21e <= 1
    0 <= f12e <= 1
    0 <= f22e <= 1
    0 <= f13e <= 1
    0 <= f23e <= 1
    0 <= f3e <= 1
     f11e+f21e+f12e+f22e+f13e+f23e+f3e  == 1
     cvx_end
    fee=[((f11e+x1(10))/2) f21e ((f12e+x1(11))/2) f22e ((f13e+x1(12))/2) f23e f3e];
x2=[fee x1(1) x1(2) x1(3) x1(4) x1(5) x1(6) x1(7) x1(8) x1(9) ];
%% Trust-region-reflective algorithm for non-linear data fitting
 opts = optimset('Display','off');
lb=[0.01 0.01 0.01 0.01 0.01 0.01 0.01 0.01 0.01 0.1 0.01 0.01 0.1 0.01 0.01 0.1];
ub=[0.8 0.8 0.8 0.8 0.8 0.8 0.8 3 3 19 3 3 19 3 3 19];
[xf,resnorm,~,exitflag,output] = lsqcurvefit(@CZDx6,x2,xdata,ydata1,lb,ub,opts);
f11_f=xf(1); f21_f=xf(2);f12_f= xf(3); f22_f= xf(4);f13_f= xf(5); f23_f= xf(6);f3_f=xf(7); theta1_f=xf(8); phi1_f=xf(9); R1_f=xf(10) ;theta2_f=xf(11); phi2_f=xf(12);R2_f=xf(13) ;theta3_f=xf(14); phi3_f=xf(15);R3_f=xf(16);

