function f = Aax_exvivo_eval(x,xdata)
% x(1) x(2) x(3)  are f1 f2 f3
% x(4) theta
% x(5) phi
% x(6) R 
% x(7) as f4
g=[xdata(:,1) xdata(:,2) xdata(:,3)];
D_intra= 0.6e3;  %(mircometer^2/sec for ex vivo)
D_iso= 2.0e3;    %(mircometer^2/sec for ex vivo)
G_mag= (xdata(:,4)./1000000); %(Tesla/micro meter)
Del=xdata(:,5);          %(in seconds)
del=xdata(:,6);          %(in seconds)
Gamma = 2.675987E8;
td=(Del-(del/3));        %(in seconds)
b=(td).*((Gamma.*del.*G_mag).^2); %(sec/mircometer^2)
sinT = sin(x(4));
cosT = cos(x(4));
sinP = sin(x(5));
cosP = cos(x(5));
n = [cosP * sinT, sinP * sinT, cosT];
%%%%%%%%%%%%%%%%%%%%%%%%%  CYLINDER %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
L=b*D_intra;
L1=L.*((g*n').^2);
am = [1.84118307861360, 5.33144196877749, 8.53631578218074, 11.7060038949077, 14.8635881488839,  18.0155278304879, 21.1643671187891, 24.3113254834588,  27.4570501848623, 30.6019229722078, 33.7461812269726,  36.8899866873805, 40.0334439409610, 43.1766274212415,  46.3195966792621, 49.4623908440429, 52.6050411092602,  55.7475709551533, 58.8900018651876, 62.0323477967829,  65.1746202084584, 68.3168306640438, 71.4589869258787,  74.6010956133729, 77.7431620631416, 80.8851921057280,  84.0271895462953, 87.1691575709855, 90.3110993488875,  93.4530179063458, 96.5949155953313, 99.7367932203820,  102.878653768715, 106.020498619541, 109.162329055405,  112.304145672561, 115.445950418834, 118.587744574512,  121.729527118091, 124.871300497614, 128.013065217171,  131.154821965250, 134.296570328107, 137.438311926144,  140.580047659913,143.721775748727, 146.863498476739,  150.005215971725, 153.146928691331, 156.288635801966,  159.430338769213, 162.572038308643, 165.713732347338,  168.855423073845, 171.997111729391, 175.138794734935,  178.280475036977, 181.422152668422, 184.563828222242,  187.705499575101];
am2=(am/x(6)).^2;
for i=1:1:60 
 num=(2*D_intra*am2(i)*del)-2+(2*exp(-(D_intra*am2(i)*del)))+...
     (2*exp(-(D_intra*am2(i)*Del)))-(exp(-(D_intra*am2(i)*(Del-del))))...
     -(exp(-(D_intra*am2(i)*(Del+del))));
 den=(D_intra^2)*(am2(i)^3)*((x(6))^2*am2(i)-1); 
 s(:,i)= num./den; 
end
 sum1=sum(s,2);
% calc g_per
 for i=1:1:max(size(g)) 
 g_per(i)=(g(i,:)*g(i,:)')-((g(i,:)*n').^2);   % G perpendicular to n
 end
L2=(2*(g_per)'.*(Gamma^2).*sum1.*G_mag.^2);
nG3=L1+L2;                   % cylinder out put            
%%%%%%%%%%%%%%%%%%%%%%%% ZEPPELIN %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
v=x(1)/(x(1)+x(2));
d_perp=D_intra*(1-v);
nG4 = (-b .* ((D_intra-d_perp)*((g * n').^2) + d_perp));
%%%%%%%%%%%%%%%%%%%%%%%%%  Ball %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG5= (D_iso * b); % Ball out put
%%%%%%%%%%%%%%%%%%%%%%%% Dot%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG6=g*[0 0 0]';  % dot out put
f=([exp(-nG3) exp(nG4) exp(-nG5) exp(-nG6)]*[x(1) x(2) x(3) x(7)]');  