function f = nod_eval_nlin(x,D_intra,D_iso,G_mag,Del,del,g,b,sigma,ydata1)
OD = x(1);
sinT=sin(x(2));
cosT=cos(x(2));
sinP=sin(x(3));
cosP=cos(x(3));
v_ic=x(4);
n=[cosP*sinT sinP*sinT cosT];
%%%%%%%%%%%%%%%%%%%%%%%%%  IntraCellular ic %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
kappa = 1 ./ tan(OD*pi/2);
signal_ic = SynthMeasWatsonSHCylNeuman_PGSE( [D_intra 0 kappa], g, G_mag, Del, del, n', 0 );
nG3=signal_ic(:,1);
%%%%%%%%%%%%%%%%%%%%%%%% Extra Cellular ec %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
d_perp=D_intra * (1 - v_ic);
signal_ec = SynthMeasWatsonHinderedDiffusion_PGSE( [D_intra d_perp kappa], g, G_mag, Del, del, n');
nG4=signal_ec(:,1);
%%%%%%%%%%%%%%%%%%%%%%%%%  ISO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG5= (D_iso * b); % Ball out put  
A_b=[nG3 nG4 exp(-nG5)];
a_hat=((inv(A_b'*A_b))*A_b')*ydata1;
y_hat=(A_b*a_hat)-sigma;
f=(ydata1-y_hat)'*(ydata1-y_hat);

