function f = noddi_eval(x,xdata)
D_intra = 1.7e3;          %(mircometer^2/sec for in vivo human)
D_iso= 3.0e3;
g=[xdata(:,1) xdata(:,2) xdata(:,3)];
G_mag= (xdata(:,4)./1000000); %(Tesla/micro meter)
Del=xdata(:,5);          %(in seconds)
del=xdata(:,6);          %(in seconds)
Gamma = 2.675987E8;
td=(Del-(del/3));        %(in seconds)
b=(td).*((Gamma.*del.*G_mag).^2); %(sec/mircometer^2)
f1=x(1);f2=x(2);f3=x(3);
%v_ic=f1/(1-f3);
v_ic=1-(f2/(1-f3));
d_perp=D_intra * (1 - v_ic);
OD = x(4);
sinT = sin(x(5));
cosT = cos(x(5));
sinP = sin(x(6));
cosP = cos(x(6));
n = [cosP * sinT sinP * sinT  cosT];
%%%%%%%%%%%%%%%%%%%%%%%%%  IntraCellular ic %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
kappa = 1 ./ tan(OD*pi/2);
signal_ic = SynthMeasWatsonSHCylNeuman_PGSE( [D_intra 0 kappa], g, G_mag, Del, del, n', 0 );
nG3=signal_ic(:,1);
%%%%%%%%%%%%%%%%%%%%%%%% Extra Cellular ec %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
signal_ec = SynthMeasWatsonHinderedDiffusion_PGSE( [D_intra d_perp kappa], g, G_mag, Del, del, n');
nG4=signal_ec(:,1);
%%%%%%%%%%%%%%%%%%%%%%%%%  ISO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nG5= (D_iso * b); % Ball out put  
f=[nG3 nG4 exp(-nG5)]*[f1 f2 f3]';
